/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.console.internal.expressions;

import com.aptana.console.ConsolePlugin;
import com.aptana.console.internal.expressions.Expression;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public final class ExpressionManager {
    private static final String EXTENSION_POINT_ID = "com.aptana.console.consoleExpressions";
    private static final String TAG_EXPRESSION = "expression";
    private static final String TAG_GROUP = "group";
    private static final String ATT_NAME = "name";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_ID = "id";
    private static final String ATT_SCOPE = "scope";
    private List<Expression> expressions = new ArrayList<Expression>();

    public ExpressionManager() {
        this.readExtensionRegistry();
        this.loadExpressions();
    }

    public StyleRange[] calculateStyles(int lineOffset, String lineText) {
        if (lineText.length() > 0) {
            for (Expression expression : this.expressions) {
                StyleRange[] result = expression.calculateStyleRanges(lineOffset, lineText);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public Color calculateBackground(String lineText) {
        if (lineText.length() > 0) {
            for (Expression expression : this.expressions) {
                Color result = expression.calculateBackground(lineText);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (TAG_EXPRESSION.equals(element.getName())) {
                this.readExpressionElement(element);
            }
            ++n2;
        }
    }

    private void readExpressionElement(IConfigurationElement element) {
        String name = element.getAttribute(ATT_NAME);
        String pattern = element.getAttribute(ATT_PATTERN);
        String scope = element.getAttribute(ATT_SCOPE);
        if (StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)pattern) || StringUtil.isEmpty((String)scope)) {
            return;
        }
        TreeMap<Integer, String> groupScopes = new TreeMap<Integer, String>();
        groupScopes.put(0, scope);
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(TAG_GROUP);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            try {
                int id = Integer.valueOf(child.getAttribute(ATT_ID));
                scope = child.getAttribute(ATT_SCOPE);
                groupScopes.put(id, scope);
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)ConsolePlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        this.expressions.add(new Expression(name, pattern, groupScopes));
    }

    private void loadExpressions() {
    }
}

